package gov.va.med.mhv.usermgmt.integration.service;

import java.util.ArrayList;

import org.tigris.atlas.service.ApplicationService;

import gov.va.med.mhv.integration.registry.transfer.Facility;
import gov.va.med.mhv.integration.registry.transfer.Patient;
import gov.va.med.mhv.integration.registry.transfer.PersonalInfo;
import gov.va.med.mhv.integration.registry.transfer.Status;

/**
 */
public interface PatientIdentityService extends ApplicationService {

	/** 
     * Name which uniquely identifies the PatientIdentity service. 
     **/
	public static final String SERVICE_NAME = 
        "gov.va.med.mhv.integration.service.PatientIdentityService";

    Patient getPatientForICN(String icn);
    
    Status finalizeCorrelation(Patient patient, Status status);
    
    Status finalizeUncorrelation(Patient patient, Status status); 

    Status updateFacilities(Patient patient,  ArrayList<Facility> facilities);

    Status updatePersonalInfo(Patient patient, PersonalInfo personalInfo); 

    Status changeIcn(Patient patient, String icn);

    Status removeCorrelation(Patient patient); 

    Status mergePatients(Patient fromPatient, Patient toPatient, 
        String referenceId);

    
}